/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.data.recipe;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.recipe.CommonMetal;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.lang.Lang;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import net.minecraft.class_7784;

public abstract class CrushingRecipeGen
extends ProcessingRecipeGen {
    protected BaseRecipeProvider.GeneratedRecipe mineralRecycling(AllPaletteStoneTypes type, Supplier<class_1935> crushed, Supplier<class_1935> nugget, float chance) {
        return this.mineralRecycling(type, b -> b.duration(250).output(chance, (class_1935)crushed.get(), 1).output(chance, (class_1935)nugget.get(), 1));
    }

    protected BaseRecipeProvider.GeneratedRecipe mineralRecycling(AllPaletteStoneTypes type, UnaryOperator<ProcessingRecipeBuilder<ProcessingRecipe<?>>> transform) {
        this.create(Lang.asId((String)type.name()) + "_recycling", b -> (ProcessingRecipeBuilder)transform.apply(b.require(type.materialTag)));
        return this.create(() -> type.getBaseBlock().get(), transform);
    }

    protected BaseRecipeProvider.GeneratedRecipe stoneOre(Supplier<class_1935> ore, Supplier<class_1935> raw, float expectedAmount, int duration) {
        return this.ore((class_1935)class_2246.field_10445, ore, raw, expectedAmount, duration);
    }

    protected BaseRecipeProvider.GeneratedRecipe deepslateOre(Supplier<class_1935> ore, Supplier<class_1935> raw, float expectedAmount, int duration) {
        return this.ore((class_1935)class_2246.field_29031, ore, raw, expectedAmount, duration);
    }

    protected BaseRecipeProvider.GeneratedRecipe netherOre(Supplier<class_1935> ore, Supplier<class_1935> raw, float expectedAmount, int duration) {
        return this.ore((class_1935)class_2246.field_10515, ore, raw, expectedAmount, duration);
    }

    protected BaseRecipeProvider.GeneratedRecipe ore(class_1935 stoneType, Supplier<class_1935> ore, Supplier<class_1935> raw, float expectedAmount, int duration) {
        return this.create(ore, b -> {
            b.duration(duration).output((class_1935)raw.get(), class_3532.method_15375((float)expectedAmount));
            float extra = expectedAmount - (float)class_3532.method_15375((float)expectedAmount);
            if (extra > 0.0f) {
                b.output(extra, (class_1935)raw.get(), 1);
            }
            b.output(0.75f, (class_1935)AllItems.EXP_NUGGET.get(), raw.get() == AllItems.CRUSHED_GOLD.get() ? 2 : 1);
            return b.output(0.125f, stoneType);
        });
    }

    protected BaseRecipeProvider.GeneratedRecipe moddedOre(CommonMetal metal, Supplier<class_1935> result) {
        class_6862<class_1792> tag = metal.ores.items();
        return this.create(String.valueOf((Object)metal) + "_ore", b -> b.duration(400).withCondition(DefaultResourceConditions.tagsPopulated((class_6862[])new class_6862[]{tag})).require(tag).output((class_1935)result.get(), 1).output(0.75f, (class_1935)result.get(), 1).output(0.75f, (class_1935)AllItems.EXP_NUGGET.get()));
    }

    protected BaseRecipeProvider.GeneratedRecipe rawOre(String metalName, Supplier<class_6862<class_1792>> input, Supplier<class_1935> result, int xpMult) {
        return this.rawOre(metalName, input, result, false, xpMult);
    }

    protected BaseRecipeProvider.GeneratedRecipe rawOreBlock(String metalName, Supplier<class_6862<class_1792>> input, Supplier<class_1935> result, int xpMult) {
        return this.rawOre(metalName, input, result, true, xpMult);
    }

    protected BaseRecipeProvider.GeneratedRecipe rawOre(String metalName, Supplier<class_6862<class_1792>> input, Supplier<class_1935> result, boolean block, int xpMult) {
        return this.create("raw_" + metalName + (block ? "_block" : ""), b -> {
            int amount = block ? 9 : 1;
            return b.duration(400).require((class_6862<class_1792>)((class_6862)input.get())).output((class_1935)result.get(), amount).output(0.75f, (class_1935)AllItems.EXP_NUGGET.get(), amount * xpMult);
        });
    }

    protected BaseRecipeProvider.GeneratedRecipe moddedRawOre(CommonMetal metal, Supplier<class_1935> result) {
        return this.moddedRawOre(metal, result, false);
    }

    protected BaseRecipeProvider.GeneratedRecipe moddedRawOreBlock(CommonMetal metal, Supplier<class_1935> result) {
        return this.moddedRawOre(metal, result, true);
    }

    protected BaseRecipeProvider.GeneratedRecipe moddedRawOre(CommonMetal metal, Supplier<class_1935> result, boolean block) {
        return this.create("raw_" + String.valueOf((Object)metal) + (block ? "_block" : ""), b -> {
            int amount = block ? 9 : 1;
            class_6862<class_1792> material = block ? metal.rawStorageBlocks.items() : metal.rawOres;
            return b.duration(400).withCondition(DefaultResourceConditions.tagsPopulated((class_6862[])new class_6862[]{material})).require(material).output((class_1935)result.get(), amount).output(0.75f, (class_1935)AllItems.EXP_NUGGET.get(), amount);
        });
    }

    public CrushingRecipeGen(class_7784 generator, String defaultNamespace) {
        super(generator, defaultNamespace);
    }

    @Override
    protected AllRecipeTypes getRecipeType() {
        return AllRecipeTypes.CRUSHING;
    }
}

